#Encapsarduino1.py    Encapsulage programme Arduino 
# Version Modifiée YLC 09012026   Compatible Windows et Linux 
#coding: utf-8
import os
import tkinter as tk
from tkinter import *
from tkinter import ttk
from tkinter import messagebox
from tkinter import filedialog
from pathlib import Path
import shutil
import json
import sys
import base64
import yaml
import subprocess
import time
import ctypes

# Détection PyInstaller / interprété
if getattr(sys, 'frozen', False):
    # Programme compilé
    loc_actu = Path(sys._MEIPASS)
else:
    # Mode interprété
    loc_actu = Path(os.path.dirname(os.path.abspath(__file__)))

# Chercher l'icône
if sys.platform.startswith("win"):
    icon_name = "Encapsule.ico"
    fallback_icon = Path(os.environ.get("APPDATA", "")) / "Encapsule" / icon_name
else:
    icon_name = "Encapsule.png"
    fallback_icon = Path.home() / ".local/share/icons" / icon_name

# Recherche de l’icône
icon_path = loc_actu / icon_name
if not icon_path.exists():
    fallback_dir = Path.home() / ".local/share/icons" if not sys.platform.startswith("win") else Path.home()
    icon_path = fallback_dir / icon_name

from datetime import datetime                     #recup date du jour
Datjour=(datetime.today().strftime("%d/%m/%Y"))   #sous forme jj/mm/aa
LocActu=os.path.abspath(os.getcwd())              # recup du repertoire courant
print("LocActu = " + LocActu)
Nomprog = ""
RepertApplis = ""
VersionCarte = "" 
CartesPath = ""
YamlFile = ""  
ErrMsg = "¤"  
AppliPath = ""
YamlPath = ""
YamlName = ""
YamlLocal = ""
CarteSelPath = ""
ProgPath = ""
InoPath = ""
ArduiName = ""
StartIde = True
CreaCarte = False
RazParam = False
CreParam = False 
ModParam = False
ListCartes = []
NomCarte = ""
PathExe = ""
           
def open_path(path):
    if sys.platform.startswith("win"):
        os.startfile(path)
    else:
        subprocess.Popen(["xdg-open", path])
 
def set_folder_icon_windows():
    # AppliPath : dossier cible (string)
    # icon_path : chemin de Encapsule.ico (Path)
    # loc_actu   : déjà calculé en amont

    if sys.platform != "win32":
        return

    try:
        # ─────────────────────────────────────────────
        # 1. Copier l’icône dans un emplacement permanent
        # ─────────────────────────────────────────────
        icon_install_dir = Path(os.environ["LOCALAPPDATA"]) / "Encapsule"
        icon_install_dir.mkdir(parents=True, exist_ok=True)

        icon_final = icon_install_dir / icon_path.name

        if not icon_final.exists():
            shutil.copy(icon_path, icon_final)

        icon_final = icon_final.resolve()

        # ─────────────────────────────────────────────
        # 2. Créer desktop.ini SANS indentation
        # ─────────────────────────────────────────────
        desktop_ini_content = (
            "[.ShellClassInfo]\r\n"
            f"IconResource={icon_final},0\r\n"
        )

        ini_path = Path(AppliPath) / "desktop.ini"

        with open(ini_path, "w", encoding="utf-16le") as f:
            f.write(desktop_ini_content)

        # ─────────────────────────────────────────────
        # 3. Attributs Windows
        # ─────────────────────────────────────────────
        os.system(f'attrib +h +s "{ini_path}"')
        os.system(f'attrib +s "{AppliPath}"')

        # ─────────────────────────────────────────────
        # 4. Rafraîchir Explorer
        # ─────────────────────────────────────────────
        ctypes.windll.shell32.SHChangeNotify(
            0x08000000, 0, None, None
        )

    except Exception as e:
        print("Erreur icône dossier :", e)

def set_folder_icon_linux(DocuPath, iconPath):
    folder = Path(DocuPath)
    icon_src = Path(iconPath)

    if not folder.is_dir():
        print("Dossier invalide :", folder)
        return
    if not icon_src.is_file():
        print("Icône introuvable :", icon_src)
        return

    # ─────────────────────────────────────────────
    # 1. Copier l’icône vers un emplacement PERMANENT
    # ─────────────────────────────────────────────
    icon_install_dir = Path.home() / ".local/share/icons"
    icon_install_dir.mkdir(parents=True, exist_ok=True)

    icon_dst = icon_install_dir / icon_src.name

    if not icon_dst.exists():
        shutil.copy(icon_src, icon_dst)

    icon_dst = icon_dst.resolve()

    # ─────────────────────────────────────────────
    # 2. Appliquer l’icône via gio (chemin PERMANENT)
    # ─────────────────────────────────────────────
    subprocess.run([
        "gio", "set", "-t", "string",
        str(folder),
        "metadata::custom-icon",
        f"file://{icon_dst}"
    ], check=False)

    # ─────────────────────────────────────────────
    # 3. Rafraîchir Nemo
    # ─────────────────────────────────────────────
    subprocess.run(["nemo", "-q"], check=False)

def Quitter():
    FormMain.quit()
    FormMain.destroy()

FormMain = tk.Tk()                                
FormMain.geometry("750x550+300+200")
FormMain.resizable(width=False, height=False)
FormMain.configure(bg='PapayaWhip') 
FormMain.title('EncapsArduino : Création ou modification d\'un programme Arduino')
FormMain.option_add('*font', ('Arial', 11))
FormMain.protocol("WM_DELETE_WINDOW", Quitter)

def show_alerte(cartename) :
    Messalert['text']="Mettre à jour la carte : "+cartename
    messagebox.deiconify()

messagebox = tk.Tk()
messagebox.title("===>  MESSAGE IMPORTANT <===")
messagebox.geometry("800x200")
messagebox.configure(bg = "Red")
messagebox.withdraw()

Messalert = Label(messagebox, text="Mettre à jour la carte : "+NomCarte,bg='White',fg='DarkRed')
Messalert.configure(font= ('Arial', 20, 'bold'))
Messalert.pack(pady=80)

def AffInfo():
    FormInfo = Toplevel(FormMain)
    FormInfo.transient(FormMain)
    FormInfo.grab_set()
    FormInfo.geometry("660x490+360+250")
    FormInfo.resizable(width=False, height=False)
    FormInfo.title("Infos")
    FormInfo.configure(bg='PowderBlue')
    LabInfo=Label(FormInfo, text="EncapsArduino permet de créer un programme arduino encapsulé.\nC\'est à dire que les cartes et librairies utilisées resteront les mêmes tout au long de\nla maintenance de ce programme sous réserve de ne pas les avoir mis à jour.\n\nLe répertoire des applications proposé est le dernier utilisé. Pour en changer il suffit\nde cliquer sur le bouton \'Répertoire des applications\' et d\'en choisir un nouveau.\n\nSi c\'est un nouveau programme, le dossier et le programme \'.ino\' sont automatiquement créés\net la main est passée automatiquement à l\'IDE Arduino. \nSi une nouvelle version de carte est choisie, le répertoire de cette version est automatiquement\ncréé mais il faudra installer cette carte dès le lancement de l\'IDE Arduino.\n\nSi c\'est une modif de programme (celui-ci existe donc dans le répertoire des applications) \net la main est passé automatiquement à l\'explorateur de fichiers pour choisir la version \ndu programme que l\'on souhaite modifier. \n\nLe dossier \'Docs\' du répertoire de ce programme contient les différentes versions du programme\nainsi que tous les documents nécessaires (Schémas,photos d\'écran, doc utilisateur... etc).\n\nLes chemins d\'accès aux librairies et au cartes utilisées par le programme sont stockés dans\nun fichier Fiparam.json créé à la première utilisation d\'EncapsArduino. \nCelui-ci peut être effacé, si on le souhaite, par la fonction \'RAZ param\' du menu.\n\nPour conserver l\'intégrité et le bon fonctionnement des programmes encapsulés, il faut passer\nsystématiquement par \'EncapArduino\' pour les modifier et les téléverser dans leur carte.\n",width=650,bg='PowderBlue',justify='left')
    LabInfo.pack()

def AffAbout():
    FormAbout = Toplevel(FormMain)
    FormAbout.transient(FormMain)
    FormAbout.grab_set()
    FormAbout.geometry("350x150+400+300")
    FormAbout.resizable(width=False, height=False)
    FormAbout.title("A propos")
    FormAbout.configure(bg='Yellow')
    LabAbout=Label(FormAbout, text=" EncapsArduino\n\nProg développé sous Python3 \net compilé par Pyinstaller\n\nAuthor : Yves Le Chevalier \nTests : Christian Fromantin\nPour :  My Human Kit\nCréé le 24 février 2025\nModifié le 09 Janvier 2026\n\n",width=350,bg='Yellow')
    LabAbout.pack()

def RazParam():                    # effacement du fichier paramètres json 
    global RazParam
    FiParam=os.path.join(LocActu,"Fiparam.json").replace("\\","/")
    if os.path.exists(FiParam) :
        os.remove(FiParam)
        print("Fichier '{FiParam}' supprimé")
        RazParam = True
        sys.exit()                 # on sort du programme en cas de suppression du fichier paramètres

        
def ClicButtonOk9():           # validation du chemin du fichier exe de l'IDE arduino
    global PathExe
    nomprov = PathExe_var.get().replace('\"',"")
    if len(nomprov) > 10 :
        PathExe=nomprov.replace("\\","/")
        print("PathExe = " + PathExe)
        LabExArdui.invisible()
        LabExeArd2['text']=PathExe
        LabExeArd1.visible()
        LabExeArd2.visible()
        TBExeArd.invisible()
        Label0.invisible()
        ButtonOK9.place(x=750, y=10)  # pour le rendre invisible
        
        
        
    
def ClicBoutYaml():             # saisie du chemin du fichier .Yaml de l'IDE arduino
    global YamlPath
    global YamlFile
    global YamlName
    FolderDialog=filedialog.askopenfilename()
    if len(FolderDialog) > 0 :
        YamlPath=os.path.dirname(FolderDialog)
        print("- YamlPath = " + YamlPath)
        YamlFile=os.path.abspath(FolderDialog).replace("\\","/")
        print("- YamlFile = " + YamlFile)
        YamlName = os.path.basename(YamlFile)
        print("- YamlName = " + YamlName)
        LabYaml2['text']=FolderDialog
        BoutYaml.invisible()
        LabYaml1.visible()
        LabYaml2.visible()
        Labelc.invisible()

def ClicBoutParam():            # saisie du chemin du repertoire des versions de cartes
    global CartesPath
    FolderParam=filedialog.askdirectory()
    if len(FolderParam) > 0 :
        CartesPath=FolderParam
        Labelb['text']=CartesPath
        BoutParam.invisible()
        Labela.visible()
        Labelb.visible()
        Labelc.invisible()
        ButtonSelect.visible()

def ClicButtonSelect():        # saisie du répertoire des applications
    global ModParam
    global RepertApplis
    FolderSelect=filedialog.askdirectory()
    if len(FolderSelect) > 0 :
        ModParam=True
        RepertApplis=FolderSelect
        Label1['text']=RepertApplis
        Label1.visible()
        ButtonOK0.visible()
        
def ClicButtonOk0():           # validation du répertoire des applications
    global CreParam
    global ModParam
    global YamlPath
    global YamlFile
    global PathExe
    Label2.visible()
    TextBox1.visible()
    TextBox1.focus_set()
    ButtonOK1.visible()
    if CreParam or ModParam :
        print("FiParam = " + FiParam)
        print("CartesPath = " + CartesPath)
        print("YamlPath = " + YamlPath)
        print("YamlFile = " + YamlFile)
        print("RepertApplis = " + RepertApplis) 
        # enregistrement du fichier paramètres avec mémo du repertoire des applications
        param = {"PathExe" : PathExe,"CartesPath" : CartesPath,"YamlPath" : YamlPath,"YamlFile" : YamlFile,"RepertApplis" : RepertApplis,}
        with open('Fiparam.json', 'w', encoding='utf-8') as fichier:
                json.dump(param, fichier, indent=2, ensure_ascii=False)
        Labelc['text']="Paramètres enregistrés dans : " + FiParam 
        Labelc.visible()
        
def ClicButtonOk1() :        # validation de la saisie du nom du programme
    global ListCartes
    global AppliPath
    global YamlLocal
    global YamlName
    global ProgPath
    global InoPath
    global ArduiName
    global NomProg
    global CartesPath
    global YamlName
    nomprov = progname_var.get()
    NomProg=nomprov. replace(" ", "")
    MessModif.visible()
    RadioBout1.invisible()
    RadioBout2.invisible() 
    if len(NomProg) > 3  :         # nom programme doit faire plus de 3 caractères
        AppliPath=os.path.join(RepertApplis,NomProg).replace("\\","/")
        YamlLocal=os.path.join(AppliPath,YamlName).replace("\\","/")
        ProgPath=os.path.join(AppliPath,"Docs").replace("\\","/")
        InoPath=os.path.join(ProgPath,NomProg+"_v1").replace("\\","/")
        ArduiName=os.path.join(InoPath,NomProg+"_v1.ino").replace("\\","/")
        print("YamlLocal = " + YamlLocal)
        print("YamlPath = " + YamlPath)
        print("ProgPath = " + ProgPath)
        print("AppliPath = " + AppliPath)
        print("CartesPath = " + CartesPath)
        print("InoPath = " + InoPath)
        print("ArduiName = " + ArduiName)
        # recup des versions de cartes déjà connues 
        chemin=CartesPath
        ListCartes=[d for d in os.listdir(chemin) if os.path.isdir(os.path.join(chemin, d))]
        ListCartes.append("AUTRE CARTE")
        Label3.visible()
        ComboBox.visible()
        ComboBox['values'] = ListCartes 
        if os.path.exists(AppliPath) :
            MessModif['text']="Ce programme existe déjà, voulez-vous le modifier ?"
            RadioBout1.visible()
            RadioBout2.visible()
            StartIde = True
        else :
            MessModif['text']="Ceci est un nouveau programme"
            RadioBout1.invisible()
            RadioBout2.invisible()
            Messereur['text']=""
    else :
        MessModif['text']="Le nom du programme doit avoir plus de 3 caractères"

def BoutRad_sel():          # saisie de la réponse si modification ou non d'un programme existant
    global YamlLocal
    global YamlPath
    global AppliPath
    global ProgPath
    Messereur['text']=""
    selection = varbout.get()
    #print(selection)
    if selection == "O" :             # réponse = OUI
        print("YamlLocal = " + YamlLocal)
        print("YamlPath = " + YamlPath)
        print("ProgPath = " + ProgPath)
        print("AppliPath = " + AppliPath)
        if os.path.exists(YamlLocal) :
               filePath = shutil.copy(YamlLocal, YamlPath)
               open_path(ProgPath)         # Ouvre l'explorateur sur le dossier programme
               FormMain.destroy()          # ferme le fenetre
               sys.exit()
        else :
               open_path(AppliPath)     # Ouvre l'explorateur sur le dossier applications 
               FormMain.destroy()          # ferme le fenetre
               sys.exit()
    else :
         Messereur['text']="Choisir dans ce cas un autre nom pour cette application"

def on_select_carte(event) :      # saisie de la version de carte choisie
    global selection
    global VersionCarte
    global CarteSelPath
    Messereur['text']=""
    TextBox.focus_set()
    selection = ComboBox.get()
    #print(selection)
    VersionCarte=selection
    Boutonvalid.visible()
    if selection == "AUTRE CARTE" :
        Label4['text']="Entrer le nom de la nouvelle version de carte"
        Label4.visible()
        TextBox.visible()
        TextBox['text']=""
    else :
        CarteSelPath=os.path.join(CartesPath,selection).replace("\\","/")
        Label4.invisible()
        TextBox.invisible()
        print ("CarteSelPath= "+CarteSelPath)

def ClicButtonValid():
    global selection, NomProg, CarteSelPath, VersionCarte, NomCarte, ErrMsg
    CreaCarte = False
    ErrMsg = ""
    Messereur['text'] = ""

    TextBox.config(state="disable")
    ComboBox.config(state="disable")

    # Gestion de la sélection de carte
    if selection == "AUTRE CARTE":
        newFolderName = TextBox.get().replace(" ", "")
        if not newFolderName:
            ErrMsg = "Saisir le nom et numéro de version de la carte"
        else:
            newCartePath = Path(CartesPath) / newFolderName
            VersionCarte = str(newCartePath)
            if newCartePath.exists():
                ErrMsg = f"La version de carte {newFolderName} existe déjà !"
            else:
                CreaCarte = True
                CarteSelPath = str(newCartePath)
                newCartePath.mkdir(parents=True, exist_ok=True)
    else:
        VersionCarte = selection
        CarteSelPath = str(Path(CartesPath) / selection)

    # Vérifications de base
    if not RepertApplis:
        ErrMsg = "Erreur : saisir le chemin du répertoire des applications"
    if not NomProg:
        ErrMsg = "Erreur : saisir un nom de programme"
    if not VersionCarte:
        ErrMsg = "Erreur : saisir une nouvelle version/n° de carte"

    if ErrMsg:
        Messereur['text'] = ErrMsg
        # Entry (tk)
        TextBox.config(state="normal")
        # Combobox (ttk)
        ComboBox.config(state="normal")
        ComboBox.update_idletasks()
        ComboBox.config(state="readonly")
        return

    # Création des dossiers du programme
    NomCarte=os.path.basename(VersionCarte)
    appli_path = Path(RepertApplis) / NomProg
    prog_docs_path = appli_path / "Docs"
    ino_path = prog_docs_path / f"{NomProg}_v1"
    ino_file = ino_path / f"{NomProg}_v1.ino"

    for p in [appli_path, prog_docs_path, ino_path]:
        p.mkdir(parents=True, exist_ok=True)

    # Création du fichier .ino
    with open(ino_file, "w") as file:
                file.write("//"+ino_file.name+"\n// Ecrit le "+Datjour+" pour carte "+NomCarte+"\n\n\nvoid setup() {\n\n\n}\n\n\nvoid loop(){\n\n\n}")

    if sys.platform == "win32":
        set_folder_icon_windows()
    else:
        # Détection du chemin de l'icône
        if getattr(sys, 'frozen', False):
            loc_actu = Path(sys._MEIPASS)
        else:
            loc_actu = Path(os.path.dirname(os.path.abspath(__file__)))
        icon_path = loc_actu / "Encapsule.png"
        set_folder_icon_linux(str(AppliPath), str(icon_path))

    # Copie et modification du fichier Arduino-cli.yaml
    shutil.copy(YamlFile, appli_path)
    YamlLocalPath = appli_path / YamlName
    with open(YamlLocalPath, "r") as file:
        config = yaml.safe_load(file)

    config["directories"]["data"] = CarteSelPath
    config["directories"]["user"] = str(appli_path)

    with open(YamlLocalPath, "w", encoding="utf-8") as file:
        yaml.safe_dump(config, file, default_flow_style=False, allow_unicode=True)

    shutil.copy(YamlLocalPath, YamlPath)

    # Lancer IDE Arduino sur le programme
    subprocess.Popen([PathExe, str(ino_path)])

    FormMain.destroy()

    if CreaCarte:
        time.sleep(4)
        show_alerte(NomCarte)                
        
#====================================================================
                

menubar = Menu(FormMain)
menu1 = Menu(menubar, tearoff=0)
menu1.add_separator()
menu1.add_command(label="Quitter", command=Quitter)
menubar.add_cascade(label="Fichier", menu=menu1)
menu2 = Menu(menubar, tearoff=0)
menu2.add_command(label="Effacer fichier paramètres", command=RazParam)
menubar.add_cascade(label="Param", menu=menu2)
menu3 = Menu(menubar, tearoff=0)
menu3.add_command(label="A propos", command=AffAbout)
menu3.add_command(label="Infos", command=AffInfo)
menubar.add_cascade(label="Aide", menu=menu3)
FormMain.config(menu=menubar)

LabExArdui=Label(FormMain, text="Fichier de l\'exe de l\'IDE Arduino ?", fg='White', bg='Teal')
LabExArdui.visible = lambda: LabExArdui.place(x=10, y=10)
LabExArdui.invisible = lambda: LabExArdui.place_forget()

LabExeArd1 = Label(FormMain, text="Fichier de l\'exe de l\'IDE Arduino : ",bg='PapayaWhip')
LabExeArd1.visible = lambda: LabExeArd1.place(x=15, y=15)
LabExeArd1.invisible = lambda: LabExeArd1.place_forget()

LabExeArd2 = Label(FormMain, text="",bg='PapayaWhip',fg='RoyalBlue')
LabExeArd2.visible = lambda: LabExeArd2.place(x=250, y=15)
LabExeArd2.invisible = lambda: LabExeArd2.place_forget()

PathExe_var = StringVar()

TBExeArd=Entry(FormMain, width=53, textvariable = PathExe_var)
TBExeArd.visible = lambda: TBExeArd.place(x=255, y=15)
TBExeArd.invisible = lambda: TBExeArd.place_forget()

ButtonOK9=Button(FormMain, text="OK", fg='Black', bg='PaleGreen',command = ClicButtonOk9)
ButtonOK9.visible = lambda: ButtonOK9.place(x=690, y=10)
ButtonOK9.invisible = lambda: ButtonOK9.place_forget()

Label0 = Label(FormMain, text="Chemin complet à copier depuis la ligne \"Cible\" dans \"Propriétés\" de l\'icone de l'IDE Arduino sur le bureau",bg='PapayaWhip',fg='DarkOliveGreen')
Label0.visible = lambda: Label0.place(x=20, y=40)
Label0.invisible = lambda: Label0.place_forget()

BoutYaml=Button(FormMain, text="Fichier \'arduino-cli.yaml\' utilisé par l\'IDE Arduino ?", fg='White', bg='Teal',command = ClicBoutYaml)
BoutYaml.visible = lambda: BoutYaml.place(x=10, y=75)
BoutYaml.invisible = lambda: BoutYaml.place_forget()

LabYaml1 = Label(FormMain, text="Fichier pref. de l'IDE Arduino : ",bg='PapayaWhip')
LabYaml1.visible = lambda: LabYaml1.place(x=15, y=80)
LabYaml1.invisible = lambda: LabYaml1.place_forget()

LabYaml2 = Label(FormMain, text="",bg='PapayaWhip',fg='RoyalBlue')
LabYaml2.visible = lambda: LabYaml2.place(x=250, y=80)
LabYaml2.invisible = lambda: LabYaml2.place_forget()

BoutParam=Button(FormMain, text="Répertoire des dossiers de versions de cartes ?", fg='White', bg='Teal',command = ClicBoutParam)
BoutParam.visible = lambda: BoutParam.place(x=10, y=110)
BoutParam.invisible = lambda: BoutParam.place_forget()

Labela = Label(FormMain, text="Répertoire des versions de cartes : ", fg='Black',bg='PapayaWhip')
Labela.visible = lambda: Labela.place(x=15, y=115)
Labela.invisible = lambda: Labela.place_forget()

Labelb = Label(FormMain, text="Répertoire des versions de cartes : ",bg='PapayaWhip',fg='RoyalBlue')
Labelb.visible = lambda: Labelb.place(x=250, y=115)
Labelb.invisible = lambda: Labelb.place_forget()

Labelc = Label(FormMain, text="Les 3 questions ci-dessus ne sont posées que lors de la première utilisation de ce programme",bg='PapayaWhip',fg='DarkOliveGreen')
Labelc.visible = lambda: Labelc.place(x=20, y=145)
Labelc.invisible = lambda: Labelc.place_forget()

ButtonSelect=Button(FormMain, text="Répertoire des applications", fg='Black', bg='PaleGreen',command = ClicButtonSelect)
ButtonSelect.visible = lambda: ButtonSelect.place(x=10, y=180)
ButtonSelect.invisible = lambda: ButtonSelect.place_forget()

Label1 = Label(FormMain, text="",bg='PapayaWhip',fg='RoyalBlue')
Label1.visible = lambda: Label1.place(x=220, y=185)
Label1.invisible = lambda: Label1.place_forget()

ButtonOK0=Button(FormMain, text="OK", fg='Black', bg='PaleGreen',command = ClicButtonOk0)
ButtonOK0.visible = lambda: ButtonOK0.place(x=670, y=180)
ButtonOK0.invisible = lambda: ButtonOK0.place_forget()

Label2= Label(FormMain, text="Entrer le nom du programme (sans .ino)",bg='PapayaWhip',fg='Black')
Label2.visible = lambda: Label2.place(x=20, y=230)
Label2.invisible = lambda: Label2.place_forget()

progname_var = StringVar()

TextBox1=Entry(FormMain,textvariable = progname_var)
TextBox1.visible = lambda: TextBox1.place(x=320, y=230)

ButtonOK1=Button(FormMain, text="OK", fg='Black', bg='PaleGreen',command = ClicButtonOk1)
ButtonOK1.visible = lambda: ButtonOK1.place(x=530, y=228)
ButtonOK1.invisible = lambda: ButtonOK1.place_forget()

Label3= Label(FormMain, text="Choix de la version de carte à utiliser",bg='PapayaWhip',fg='Black')
Label3.visible = lambda: Label3.place(x=20, y=330)
Label3.invisible = lambda: Label3.place_forget()

ComboBox = ttk.Combobox(FormMain, values= ListCartes, state="readonly")
ComboBox.width=200
ComboBox.height=30
ComboBox.bind("<<ComboboxSelected>>", on_select_carte)
ComboBox.visible = lambda: ComboBox.place(x=320, y=330)

MessModif= Label(FormMain, text="",bg='PapayaWhip',fg='Red')
MessModif.configure(font= ('Arial', 11, 'bold'))
MessModif.visible = lambda: MessModif.place(x=75, y=275)
MessModif.invisible = lambda: MessModif.place_forget()

varbout = StringVar()
varbout .set("-1")

RadioBout1= Radiobutton(FormMain, text="Oui", variable=varbout, value="O", command=BoutRad_sel)
RadioBout1.visible = lambda: RadioBout1.place(x=490, y=273)
RadioBout1.invisible = lambda: RadioBout1.place_forget()

RadioBout2= Radiobutton(FormMain, text="Non", variable=varbout, value="N", command=BoutRad_sel)
RadioBout2.visible = lambda: RadioBout2.place(x=560, y=273)
RadioBout2.invisible = lambda: RadioBout2.place_forget()

Label4= Label(FormMain, text="",bg='PapayaWhip',fg='Black')
Label4.visible = lambda: Label4.place(x=20, y=380)
Label4.invisible = lambda: Label4.place_forget()

noucarte_var = StringVar()

TextBox=Entry(FormMain,textvariable = noucarte_var)
TextBox.visible = lambda: TextBox.place(x=320, y=380)
TextBox.invisible = lambda: TextBox.place_forget()

Boutonvalid=Button(FormMain, text="Valider", fg='Black', bg='PaleGreen',command = ClicButtonValid)
Boutonvalid.visible = lambda: Boutonvalid.place(x=350, y=430)

Messereur= Label(FormMain, text="",bg='PapayaWhip',fg='Red')
Messereur.configure(font= ('Arial', 12, 'bold'))
Messereur.visible = lambda: Messereur.place(x=150, y=500)
Messereur.invisible = lambda: Messereur.place_forget()
Messereur.visible()

#-----------------------------------------------------------------------
      
# Test presence du fichier parametres json
FiParam=os.path.join(LocActu,"Fiparam.json").replace("\\","/")
try:
    with open(FiParam, 'r', encoding='utf-8') as fichier:
        Param = json.load(fichier)

except IOError:
    CreParam = True
    LabExArdui.visible()
    Label0.visible()
    TBExeArd.visible()
    ButtonOK9.visible()
    BoutParam.visible()
    BoutYaml.visible()
    Labelc.visible()
    TBExeArd.focus_set()
else :
    print(Param)
    CartesPath = Param["CartesPath"]
    LabExeArd1.visible()
    PathExe=Param["PathExe"]
    LabExeArd2['text']=PathExe
    LabExeArd2.visible()
    Labela.visible()
    Labelb['text'] = CartesPath
    Labelb.visible()
    RepertApplis = Param["RepertApplis"]
    ButtonSelect.visible()
    Label1['text'] = RepertApplis
    Label1.visible()
    YamlPath = Param["YamlPath"]
    LabYaml1.visible()
    LabYaml2['text'] = Param["YamlFile"]
    LabYaml2.visible()
    YamlFile = Param["YamlFile"]
    YamlName = os.path.basename(YamlFile)
    print ("YamlName= "+YamlName)
    Labelc['text'] = "(Paramètres ci-dessus issus de " + FiParam
    Labelc.visible()
    ButtonOK0.visible()

FormMain.mainloop()

#=======================================================================


